package com.ejie.p06b.dokusi;

import com.ejie.p06b.util.P06BParametros;

public abstract class P06bDokusiUtiles {

	// Separador utilizado en el audit user

	private static final String SEP_AUDIT_USER = "#";

	/**
	 * 
	 * @param strAuditUser
	 * @param appProperties
	 * @return
	 */
	public static String obtenerAuditUserDefecto(String strAuditUser) {
		String ret = strAuditUser;
		if ((ret == null) || "".equals(ret.trim())) {
			// p43bClsLog.debug("Usa auditUser por defecto");
			// Modif 09/05/2013: nueva propiedad con usuario de Dokusi
			// String codigoAplic = p43bFicheroIni.getCodigoAplicacion();
			String codigoAplic = P06BParametros.get("tokenAplicDokusiWS");

			// Modif 07/06/2013: desde Dokusi nos indican que debe tener 3
			// valores y no 4
			// ret = obtenerAuditUser(codigoAplic, codigoAplic, codigoAplic,
			// codigoAplic);
			ret = obtenerAuditUser(codigoAplic, codigoAplic, codigoAplic, null);
		}
		return ret;
	}

	/**
	 * @param dni
	 * @param nombre
	 * @param usuario
	 *            (opcional)
	 * @param aplicacion
	 *            (opcional)
	 * @return Cadena que se usará para el parametro auditUser del webservice.
	 *         Es de la forma: DNI#Nombre#[Usuario]#[aplicacion] Retorna null si
	 *         se produce algún error.
	 */
	private static String obtenerAuditUser(String dni, String nombre,
			String usuario, String aplicacion) {
		StringBuffer strAuditUser = new StringBuffer();
		try {
			// Dni y nombre son obligatorios
			if (dni == null || "".equals(dni.trim())
					|| nombre == null
					|| "".equals(nombre.trim())) {
				// p43wClsLog.error("Error obtenerAuditUser. Dni y nombre son obligatorios");
				return null;
			}
			strAuditUser.append(dni);
			strAuditUser.append(SEP_AUDIT_USER);
			strAuditUser.append(nombre);
			if (!( usuario == null || ("".equals(usuario.trim())) )) {
				strAuditUser.append(SEP_AUDIT_USER);
				strAuditUser.append(usuario);
			}
			if (!( aplicacion == null || ("".equals(aplicacion.trim())) )) {
				strAuditUser.append(SEP_AUDIT_USER);
				strAuditUser.append(aplicacion);
			}
			// p43wClsLog.debug("obtenerAuditUser: " + strAuditUser.toString());
			return strAuditUser.toString();
		} catch (Exception e) {
			// p43wClsLog.error("Excepcion P43BClienteDokusi.obtenerAuditUser",
			// e);
			return null;
		}
	}
}
